# OraAI电商场景
本工程使用电商数据分析为案例，介绍如何使用OraAI进行自然语言分析。参考[5分钟上手OraAI](https://docs.oraai.chat/quickstart/get-start.html)。

## 示例工程
下载电商场景示例工程[ora-project-ec.zip](https://downloads.oraai.chat/ora-projects/ora-project-ec.zip)。

### 目录结构
```shell
orai-project-ec/
├── ora.yml                     # 项目配置文件
├── models/                     # 模型文件目录
│    └── fct_order_main.yml     # 订单表模型文件
├── sqls/                       # SQL文件目录
│    └── fct_order_main.sql     # 订单表SQL查询
├── images/                     # README图片
│    └── ......
└── README.md                   # 项目说明
```

## 1.登录平台
1. 打开浏览器，输入`http://218.1.66.142:3000/`。
2. 输入用户名和密码，登录平台。

## 2.建立数据源
1. 点击左下角头像，在弹出菜单中，选择`数据源`。
![数据源](./images/数据源菜单.png)
2. 点击`新建数据源`。
![新建数据源](./images/新建数据源.png)
3. 选择数据库类型。
![选择数据库类型](./images/选择数据库类型.png)
4. 输入数据库连接信息。
![填写数据库连接信息](./images/填写数据库连接信息.png)
**注意：**
- 数据源名称必须为英文名字。
- 数据源名称必须与ora.yml中的data_source_name名称一致。
5. 可以使用平台提供的电商模拟数据作为数据源。
![电商模拟数据](./images/电商模拟数据.png)

    | 参数         | 值            |
    |------------|--------------|
    | 名称         | ECDemo       |
    | 主机名        | 127.0.0.1    |
    | 端口         | 9030         |
    | 密码         | 0raA14ec!    |
    | 数据库名称      | ec_demo      |
    | 用户名        | ec_user      |
    | 数据库类型      | MySQL        |

6. 查看数据源状态。状态为`已连接`表示连接成功。
![查看数据源状态](./images/已连接.png)

## 3.下载工程。
1. 下载电商语义模型示例工程。[ora-project-ec.zip](https://downloads.oraai.chat/ora-projects/ora-project-ec.zip)。
2. 解压工程。
```shell
$ unzip ora-project-ec.zip
```
3. 进入工程目录。
```shell
$ cd ora-project-ec
```
## 4.安装客户端
1. 安装orai-cli客户端。参考[orai-cli 安装和配置指南](https://docs.oraai.chat/cli/installation.html)。
2. 在`OraAI智能分析平台`获取API秘钥。依次点击设置->API秘钥->创建新API秘钥。并复制API秘钥。
![获取API秘钥](./images/获取API秘钥.png)
![复制API秘钥](./images/复制API秘钥.png)
3. 配置orai-cli客户端。设置环境变量。
**注意：**
- 替换`http://218.1.66.142:3001`为`OraAI智能分析平台`地址。
- `OraAI智能分析平台`API服务端口为`3001`，不能更改。
- 替换`xxxxxx`为复制的API秘钥。
```shell
$ export ORAI_HOST=http://218.1.66.142:3001
$ export ORAI_API_KEY=xxxxxxxx
```
4. 使用orai-cli客户端进行认证。
```shell
$ orai-cli auth
✅ 您已成功连接到 OraAI!
连接详情:
host: http://218.1.66.142:3001
api_key: ****XXXXX
凭据保存成功!
```
5. 进入工程。
```shell
$ cd ora-project-ec
```
6. 解析工程。
```shell
$ orai-cli parse
```
7. 上传工程。
```shell
$ orai-cli deploy
```

8. 登录`OraAI智能分析平台`，查看数据集。
![查看数据集列表](./images/查看数据集列表.png)
![查看数据集SQL](./images/查看数据集SQL.png)
![查看数据集元数据](./images/查看数据集元数据.png)

## 5.用户提问
1. 登录`OraAI智能分析平台`。
2. 输入问题进行提问。
![输入问题](./images/输入问题.png)
![自我介绍](./images/自我介绍.png)
3. 分析电商数据。
- **请帮我分析不同店铺的订单量。**
![请帮我分析不同店铺的订单量](./images/请帮我分析不同店铺的订单量.png)
![生成指标文件](./images/生成指标文件.png)
![展示分析结果](./images/展示分析结果.png)
4. 顾问型分析。
- **最近销量下降，如何挽回。**
![顾问型分析](./images/顾问型分析.png)
5. 学习型分析。
- **对比各渠道销售数据。**
![对比各渠道销售数据](./images/对比各渠道销售数据.png)
- **分析主播-016的成功经验，复制到其他渠道。**
![学习销冠经验](./images/学习销冠经验.png)
![总结销冠成功经验](./images/总结销冠成功经验.png)
6. 分析提示词。
    1. 基础分析
    - **请帮我分析不同店铺的订单量。**
    - **请帮我分析不同商品的订单量。**
    - **请帮我分析不同商品的出库数量、退货数量和退货率。在一张图表中展示，用柱状折线图。**
    - **请帮我统计销售前三名的商品本月的同环比变化。**
    2. 顾问型分析
    - **最近销量下降，如何挽回。**
    3. 学习型分析
    - **对比各渠道销售额。**
    - **分析主播-016的成功经验，复制到其他渠道。**
