## 目录结构

### 特别注意
1. 数据集预览页面的指标字段建议设置成double，与数据库类型保持一致。
    ```shell
    $ python3 /home/datax/bin/datax.py /home/ora-project-k3cloud/etl/datax_t_pur_poorder.json
    ```
1. 使用MySQL客户端连接StarRocks，端口使用9030
    ```shell
    $ mysql -h 218.1.66.142 -P 9030 -u root -pbi123456
    ```

    ```sql
    use dbt_dwm;                        -- 切换数据库
    desc T_BD_DEPARTMENT;               -- 查看表结构
    DROP TABLE dbt_dwm.T_BD_DEPARTMENT; -- 删除表
    ```

1. 根据`提示datax同步脚本提示词`，生成查询语句。

    1. 部门
        ```sql 
        SELECT 
            d.FDEPTID AS DepartmentID,      -- 部门ID
            d.FNUMBER AS DepartmentCode,    -- 部门编码
            dl.FNAME AS DepartmentName      -- 部门名称
        FROM 
            T_BD_DEPARTMENT d               -- 部门表
        LEFT JOIN 
            T_BD_DEPARTMENT_L dl            -- 部门多语言表 
        ON 
            d.FDEPTID = dl.FDEPTID
        WHERE 
            dl.FLOCALEID = 2052             -- 中文语言标识
        ORDER BY 
            d.FLEVELCODE;
        ```

    1. 物料信息
        ```sql
        SELECT 
            m.FMATERIALID AS 物料内码, 
            m.FNUMBER AS 编码, 
            m.FMATERIALGROUP AS 物料组别,
            m.FUSEORGID AS 使用组织,
            l.FNAME AS 物料名称
        FROM 
            T_BD_MATERIAL m                 -- 物料主表
        JOIN 
            T_BD_MATERIAL_L l               -- 物料多语言表
        ON 
            m.FMATERIALID = l.FMATERIALID
        ```

    1. 供应商
        ```sql
        SELECT
            S.FSUPPLIERID AS SUPPLIER_ID,   --供应商内码
            S.FUSEORGID AS USE_ORG_ID,      --使用组织内码
            L.FNAME AS NAME                 --名称
        FROM 
            T_BD_SUPPLIER S
        JOIN 
            T_BD_SUPPLIER_L L ON S.FSUPPLIERID = L.FSUPPLIERID
        WHERE 
            L.FLOCALEID = 2052              --中文版本
        ```

    1. 采购订单
        ```sql
        SELECT 
            PO.FID AS ORDER_ID,             -- 单据内码
            PO.FBILLNO AS BILL_NO,          -- 单据编号
            PO.FDATE AS ORDER_DATE,         -- 采购日期
            PO.FSUPPLIERID AS SUPPLIER_ID,  -- 供应商
            PO.FPURCHASEDEPTID AS PURCHASE_DEPT_ID, -- 采购部门
            PE.FENTRYID AS ENTRY_ID,        -- 分录内码
            PE.FMATERIALID AS MATERIAL_ID,  -- 物料
            PE.FQTY AS QUANTITY,            -- 数量
            PE.FBASEUNITQTY AS BASE_UNIT_QUANTITY, -- 基本单位数量
        FROM
            T_PUR_POORDER PO
        JOIN 
            T_PUR_POORDERENTRY PE ON PO.FID = PE.FID
        ```

    1. 采购订单明细
        ```sql
        SELECT 
            PO.FID AS ORDER_ID,             -- 单据内码
            PO.FBILLTYPEID AS BILL_TYPE_ID, -- 单据类型
            PO.FBILLNO AS BILL_NO,          -- 单据编号
            PO.FDATE AS ORDER_DATE,         -- 采购日期
            PO.FSUPPLIERID AS SUPPLIER_ID,  -- 供应商
            PO.FPURCHASEDEPTID AS PURCHASE_DEPT_ID, -- 采购部门
            PE.FMATERIALID AS MATERIAL_ID,  -- 物料
            PE.FSALQTY AS SAL_QTY,          -- 销售数量
            PE.FSTOCKQTY AS STOCK_QTY       -- 库存数量
        FROM 
            T_PUR_POORDER PO
        JOIN 
            T_PUR_POORDERENTRY PE ON PO.FID = PE.FID
        ```