### DataX 同步脚本生成需求
1. 请根据用户输入的查询语句并参考下面的信息和例子，生成并保存 DataX 同步脚本。存放路径：./etl，脚本文件名：datax_t_pur_poorder.json。
    ```sql
    SELECT FBILLNO,FDATE,FSUPPLIERID from T_PUR_POORDER
    ```

1. 目标表创建脚本，存放路径：./etl， 脚本文件名：datax_t_pur_poorder.sql。
    ```sql
    CREATE TABLE IF NOT EXISTS T_PUR_POORDER (
    FBILLNO VARCHAR(50),
    FDATE DATE,
    FSUPPLIERID INT
    ) ENGINE=OLAP
    PRIMARY KEY(FBILLNO)
    DISTRIBUTED BY HASH(FBILLNO) BUCKETS 10
    PROPERTIES (
    "replication_num" = "1",
    "storage_format" = "V2"
    );
    ```

1. 创建表的字段类型根据源数据库字段类型匹配映射starrocks的对应字段类型，匹配规则如下： 
    - 源数据库字段类型为 VARCHAR 时，目标数据库字段类型为 VARCHAR
    - 源数据库字段类型为 DATE 时，目标数据库字段类型为 DATE
    - 源数据库字段类型为 INT 时，目标数据库字段类型为 INT
    - 源数据库字段类型为 DECIMAL 时，目标数据库字段类型为 DOUBLE
    - 源数据库字段类型为 FLOAT 时，目标数据库字段类型为 FLOAT
    - 源数据库字段类型为 DOUBLE 时，目标数据库字段类型为 DOUBLE
    - 源数据库字段类型为 BOOLEAN 时，目标数据库字段类型为 BOOLEAN
    - 源数据库字段类型为 TIMESTAMP 时，目标数据库字段类型为 TIMESTAMP

1. 在 StarRocks 中为表名和字段添加中文别名
    ```sql
    ALTER TABLE dbt_dwm.T_PUR_POORDER 
    COMMENT = "采购订单信息表";
    ```

#### 源数据库信息（SQL Server）
- IP 地址：192.168.31.230
- 端口号：1433
- 用户名：sa
- 密码：yourStrong@assword
- 数据库实例：蓝海实业集团
- 查询语句：SELECT FBILLNO,FDATE,FSUPPLIERID from T_PUR_POORDER

#### 目标数据仓库信息（StarRocks）
- IP 地址：218.1.66.142
- 端口号：9030
- 用户名：root
- 密码：bi123456
- 数据库实例：dbt_dwm
- 目标表：T_PUR_POORDER

#### 生成同步脚本

```shell
$ python3 /home/datax/bin/datax.py  ./etl/datax_t_pur_poorder.json
```

#### 生成的脚本内容示例（需根据上述信息完善）

```json
{
"job": {
    "setting": {
      "speed": {
        "channel": 1
      }
    },
    "content": [
      {
        "reader": {
          "name": "sqlserverreader",
          "parameter": {
            "username": "SA",  
            "password": "yourStrong@assword",  
            "connection": [
              {   
                "jdbcUrl": ["jdbc:sqlserver://192.168.31.230:1433;databaseName=蓝海实业集团;encrypt=true;trustServerCertificate=true"],
                "querySql": ["SELECT FBILLNO, FDATE, FSUPPLIERID FROM T_PUR_POORDER"]
              }
            ]
          }
        },
        "writer": {
          "name": "starrockswriter",
          "parameter": {
            "loadUrl": ["218.1.66.142:8030"],
            "jdbcUrl": "jdbc:mysql://218.1.66.142:9030/dbt_dwm",
            "username": "root",
            "password": "bi123456",
            "database": "dbt_dwm",
            "table": "T_PUR_POORDER",
            "writeMode": "insert",
            "column": ["FBILLNO", "FDATE", "FSUPPLIERID"],
            "batchSize": 10240,
            "timeout": 60
          }
        }
      }
    ]
  }
}
```