CREATE TABLE IF NOT EXISTS dbt_dwm.T_PUR_POORDER (
  ORDER_ID VARCHAR(50) COMMENT '单据内码',
  BILL_TYPE_ID VARCHAR(50) COMMENT '单据类型',
  BILL_NO VARCHAR(50) COMMENT '单据编号',
  ORDER_DATE DATE COMMENT '采购日期',
  SUPPLIER_ID INT COMMENT '供应商',
  PURCHASE_DEPT_ID INT COMMENT '采购部门',
  MATERIAL_ID INT COMMENT '物料',
  SAL_QTY DOUBLE COMMENT '销售数量',
  STOCK_QTY DOUBLE COMMENT '库存数量'
) ENGINE=OLAP
PRIMARY KEY(ORDER_ID)
DISTRIBUTED BY HASH(ORDER_ID) BUCKETS 10
PROPERTIES (
    "replication_num" = "1",
    "storage_format" = "V2"
);

ALTER TABLE dbt_dwm.T_PUR_POORDER 
COMMENT = "采购订单信息表";