## 采购分析需求整理(最佳实践案例)

### 采用此种最佳实践的方案特点
- 使用 Trae 可以减少90%的编码成本。
- 基于 K3cloud 数据字典，作为数据模型的基础。

### 基础表
- T_BD_SUPPLIER 供应商
- T_BD_SUPPLIER_L 供应商多语言
- T_BD_DEPARTMENT 部门表
- T_BD_DEPARTMENT_L 部门多语言表
- T_BD_MATERIAL 物料
- T_BD_MATERIAL_L 物料多语言

### 采购订单相关表清单
- T_PUR_POORDER 采购订单
- T_PUR_POORDERENTRY 采购订单明细

最佳实践方法：
1. 使用 PDM 工具导出K3cloud数据字典中采购订单相关表清单的 MD 文件。
2. 依据 K3cloud 数据表文件生成对应的 DataX 配置文件。
   由于 K3CLOUD 中单个表的完整信息可能分散存储在多个表中，需执行多表合并操作，并生成相应的查询 SQL 语句，用于 DataX 配置文件的生成。
   在 Trae 对话框输入：“生成一个用于合并两个表的 SELECT 查询语句”，并确保以下几点：
   - 所有表名和字段名均使用大写英文表示。
   - 每个字段后添加 `--备注` 格式的备注说明。
   - 使用 `AS` 关键字将字段重命名为与中文备注对应的英文名称。
   - 示例输出需符合 SQL 语法规范，可直接运行。
   - 显示所有字段。
   - 如果查询有带_L结尾的多语言表有多个语言版本，需根据 `FLOCALEID` 字段进行筛选，确保只取等于2052的中文版本，其他表则直接查询。

3. 参考 `datax同步脚本提示词.md` 中的提示内容配置 SQL 语句，生成 DataX 配置文件和目标库建表脚本。
   保存生成的脚本后，按照执行脚本启动数据同步任务。
4. 基于生成的目标表 SQL 创建脚本生成 SELECT 查询 SQL 脚本，并在 `models/sql` 目录下创建对应的 SQL 文件。
5. 依据 `开发规范.md`、和 `sql/T_BD_DEPARTMENT.sql` 完善 `models/BD_DEPARTMENT.yml` 按照对应的SQL更新（dimensions、measures、metrics、filters）等配置信息，同时补充表和字段名的备注说明,去掉对应sql文件中不存在的字段配置信息。
6. 验证并发布模型到服务器
   6.1 配置环境变量
       ```bash
       export ORAI_API_KEY="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjE5MTA2Nzc1NDQsImF1ZCI6ImFwaSIsInN1YiI6IjIzNjM4ODE2LTQxMDktNDJhZC1hNTY3LTU5ZjY5MGZhNmQyZiJ9.EF_csyIoZEut3D9RHZZw_eFGwYjT2BWrco0GXxlH-7w"
       export ORAI_HOST="http://218.1.66.142:3001"
       ```
   6.2 校验认证信息
       ```bash
       /home/orai/cli/target/release/orai-cli auth
       ```
   6.3 验证语义模型
       ```bash
       /home/orai/cli/target/release/orai-cli parse
       ```
   6.4 部署模型
       ```bash
       /home/orai/cli/target/release/orai-cli deploy
       ```

   对话问题：
   1、2018年贡献度高的供应商有哪些？

### 注意事项
1. StarRocks 表字段命名需使用英文，避免使用中文名
2. StarRocks 表字段命名应避免使用特殊字符，确保字段名符合规范

### 优化建议
将 `models` 目录添加到对话中，输入提示词："分析 YML 文件之间的关联关系，并补充中文语义定义"

<<<<<<< HEAD
### 项目结构
=======
项目结构：
>>>>>>> 81c7a2fe9806531503bd1adde1319487ff80f452
```text
# /home/ora-project-k3cloud/
├── README.md                      # 项目的说明文档，通常包含项目概述、使用方法等基本信息
├── datax同步脚本提示词.md           # 用于配置DataX同步脚本的提示内容文档，参考该文档可生成DataX配置文件和目标库建表脚本
├── etl/                           # 数据提取、转换和加载（ETL）相关文件的目录
│   ├── datax_t_pur_poorder.json   # 采购订单相关的DataX配置文件，用于配置数据同步任务
│   └── datax_t_pur_poorder.sql    # 采购订单相关的SQL文件，为DataX配置文件生成提供查询语句
├── k3cloud 数据表/                 # 存放从K3cloud数据字典导出的采购订单相关表清单的MD文件目录
│   ├── T_PUR_POORDER.md           # 采购订单表T_PUR_POORDER的数据字典信息文档
│   ├── T_PUR_POORDERENTRY.md      # 采购订单明细表T_PUR_POORDERENTRY的数据字典信息文档
│   └── 提示词.md                   # 包含导出或处理K3cloud数据表相关的提示信息文档
├── models/  # 存放模型相关文件的目录
│   ├── T_BD_SUPPLIER.yml          # 供应商表T_BD_SUPPLIER的模型配置文件，包含维度、度量等配置信息
│   └── sql/  # 存放SQL脚本的子目录
│       └── T_BD_SUPPLIER.sql      # 供应商表T_BD_SUPPLIER的SELECT查询SQL脚本
├── ora.yml                        # 项目整体的配置文件，用于配置项目相关的参数
├── 在线文档.md                     # 项目的在线文档，可能包含项目使用教程、接口文档等信息
├── 开发规范.md                     # 项目开发过程中遵循的规范文档，指导代码编写和项目实现
└── 实现步骤.md                     # 记录项目最佳实践实现步骤的文档
```
