# OraAI语义模型模板
该项目包含了OraAI语义模型的标准样例，开发者可以基于该样例进行自定义开发。

## 目录结构
```markdown
orai_sample_project/
├── ora.yml                 # 项目配置文件
├── models/                 # 语义模型定义
│   └── fct_order_main.yml  # 订单表语义模型
└── sqls/                   # 模型数据定义
    └── fct_order_main.sql  # 订单表SQL查询
```

### 1. ora.yml
定义了项目基础信息，如项目数据源、模型数据文件目录、语义模型文件目录等。

### 2. sqls/
定义了模型数据来源，每个模型对应一个SQL文件，文件中定义了模型数据的查询语句。

### 3. models/
定义了语义模型，每个模型对应一个YAML文件，文件中定义了维度、度量、指标、过滤器、关联关系等。

## 使用方式
1. 安装orai-cli命令行工具
    参考[orai-cli安装和配置指南](http://218.1.66.142:8888/cli/installation.html#orai-cli-%E5%AE%89%E8%A3%85%E5%92%8C%E9%85%8D%E7%BD%AE%E6%8C%87%E5%8D%97)

1. 进入项目目录
    ```bash
    $ cd /Workspace/orai_sample_project
    models          ora.yml         README.md       sqls
    ```

1. 完成身份认证
    ```bash
    # 设置OraAI API主机密钥
    $ export ORAI_API_KEY="xxxxxxxxxx"
    # 设置OraAI API主机URL
    $ export ORAI_HOST="http://192.168.1.88:3001"
    $ orai-cli auth
    ✅ 您已成功连接到 OraAI!

    连接详情:
    host: http://192.168.1.88:3001
    api_key: ************

    凭据保存成功!
    ```

1. 验证模型文件
    ```bash
    $ orai-cli parse
    🚀 开始 OraAI 模型解析...

    ⚙️ 正在查找 ora.yml 配置...
    ✅ 在 /Workspace/ora_ai/orai-sample-project/ora.yml 找到 ora.yml
    有效配置目录: /Workspace/ora_ai/orai-sample-project

    ℹ️ 使用 ora.yml 中的有效语义模型路径:
    - 路径: /Workspace/ora_ai/orai-sample-project/./models, 上下文: DefaultProjectContext

    找到 1 个语义模型 .yml 文件要解析。

    ✨ 开始解析和验证过程...
    [1/1] 解析: models/fct_order_main.yml
    ✅ 解析和验证: fct_order_main

    📊 解析命令总结
    ======================================
    已扫描文件数量                   : 1
    已处理文件数量                   : 1
    文件排除 (由于模式)  : 0
    成功解析的模型        : 1
    有错误的模型        : 0

    ✅ 成功解析的模型:
    - fct_order_main (in file: models/fct_order_main.yml)
    ======================================
    🎉 所有指定的模型文件解析成功!
    ```

1. 上传模型文件
    ```bash
    $ orai-cli deploy
    🚀 开始 OraAI 部署过程...
    工作目录: /Workspace/ora_ai/orai-sample-project

    [0/0] 处理: 
    状态: 正在搜索 ora.yml 配置...
    ✅ 在 /Workspace/ora_ai/orai-sample-project/ora.yml 找到 ora.yml 配置

    🔍 扫描语义模型目录用于项目 'DefaultProjectContext': ./models

    [0/1] 处理: models/fct_order_main.yml
    状态: 解析项目 'DefaultProjectContext' 中的模型 'fct_order_main.yml'...

    [1/1] 处理: fct_order_main (from fct_order_main.yml in project 'DefaultProjectContext')
    状态: 解析模型 'fct_order_main' 的 SQL...
    ➡️ 找到模型 'fct_order_main' 的 SQL 文件: /Workspace/ora_ai/orai-sample-project/./sqls/fct_order_main.sql
    👍 模型 'fct_order_main' 准备部署.

    ℹ️  从 ora.yml 中处理了 semantic_model_paths。跳过扫描单个 .yml 文件。

    🚀 部署 1 个模型到 OraAI Cloud...

    🔬 验证 OraAI Cloud 的部署结果...

    🔍 验证模型: fct_order_main
    数据源: ec_db
    模式: ec_dwd

    📊 部署说明
    ======================================
    成功部署 (新或更新): 1 模型
    ✨ 部署新模型: 1
    ======================================
    🎉 所有指定的模型都成功处理!
    ```


